library(hht)
data(PortFosterEvent)
trials.dir <- "transient_eemd"
trials <- 100
nimf <- 10

eemd.result <- EEMDCompile(trials.dir, trials, nimf)

dt <- mean(diff(tt))
dfreq <- 0.05
freq.span <- c(0, 30)
time.span <- c(5, 10)

hgram <- HHRender(eemd.result, dt, dfreq, 
freq.span = freq.span, time.span = time.span)
time.span <- c(5, 10)
freq.span <- c(0, 25)
amp.span <- c(0.000001, 0.00002)
cluster.span <- c(3, 100)
main="DECEPTION ISLAND STATION 301 2005-01-30 05:54:51.232"

postscript(file="../figure_06_col.eps")
HHGramImage(hgram, time.span = time.span, freq.span = freq.span,
    amp.span = amp.span, cluster.span = cluster.span, main=main,
    img.x.lab = "Time (s)", img.y.lab = "Frequency (Hz)",
    pretty = TRUE, img.x.format = "%.1f", img.y.format = "%0d")
dev.off()
colormap=rev(gray(0:300/500))
backcol=rep(255, 3)

postscript(file="../figure_06_bw.eps")
HHGramImage(hgram, time.span = time.span, freq.span = freq.span,
    amp.span = amp.span, cluster.span = cluster.span, main=main,
    img.x.lab = "Time (s)", img.y.lab = "Frequency (Hz)",
    pretty = TRUE, img.x.format = "%.1f", img.y.format = "%0d",
    colormap = colormap, backcol = backcol)
dev.off()

